/*
 * Decompiled with CFR 0.152.
 */
package lotr.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import lotr.common.LOTRCreativeTabs;
import lotr.common.LOTRDamage;
import lotr.common.LOTRLevelData;
import lotr.common.LOTRMod;
import lotr.common.LOTRPlayerData;
import lotr.common.enchant.LOTREnchantmentHelper;
import lotr.common.entity.animal.LOTREntityFox;
import lotr.common.entity.npc.LOTREntityAngbandBerserker2;
import lotr.common.entity.npc.LOTREntityElf;
import lotr.common.fac.LOTRFaction;
import lotr.common.item.LOTRMaterial;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class LOTRBlockQuagmire3
extends Block {
    private float slowdownFactor;
    private int ticksSinceLastDamage = 0;
    private static final int DAMAGE_INTERVAL = 80;
    private static final long DAMAGE_COOLDOWN = 2000L;
    private Map<Entity, Long> lastDamageTimeMap = new HashMap<Entity, Long>();

    public LOTRBlockQuagmire3() {
        super(Material.field_151597_y);
        this.func_149711_c(10.0f);
        this.func_149752_b(2.0f);
        this.func_149672_a(field_149773_n);
        this.func_149647_a(LOTRCreativeTabs.tabBlock);
        this.slowdownFactor = 0.9f;
    }

    public AxisAlignedBB func_149668_a(World world, int i, int j, int k) {
        AxisAlignedBB boundingBox = AxisAlignedBB.func_72330_a((double)i, (double)j, (double)k, (double)((double)i + 1.0), (double)((double)j + 1.0), (double)((double)k + 1.0));
        double expand = 1.0;
        AxisAlignedBB expandedBox = boundingBox.func_72314_b(expand, expand, expand);
        for (Object obj : world.func_72872_a(Entity.class, expandedBox)) {
            if (!(obj instanceof Entity)) continue;
            Entity entity = (Entity)obj;
            if (entity instanceof EntityPlayer) {
                ItemStack armorItemStack;
                EntityPlayer player = (EntityPlayer)entity;
                LOTRPlayerData playerData = LOTRLevelData.getData(player);
                LOTRFaction pledgeFaction = playerData.getPledgeFaction();
                if (pledgeFaction != null) {
                    float reputation = playerData.getAlignment(pledgeFaction);
                    Set<LOTRFaction.FactionType> factionTypesSet = pledgeFaction.getFactionTypes();
                    EnumSet<LOTRFaction.FactionType> factionTypes = EnumSet.copyOf(factionTypesSet);
                    LOTRFaction.FactionType factionType = this.getPriorityFactionType(factionTypes);
                    if (reputation >= 5000.0f && factionType == LOTRFaction.FactionType.TYPE_ELF) {
                        entity.field_70143_R = 0.0f;
                        return super.func_149668_a(world, i, j, k);
                    }
                }
                if ((armorItemStack = player.func_71124_b(1)) == null || !(armorItemStack.func_77973_b() instanceof ItemArmor)) continue;
                ItemArmor armor = (ItemArmor)armorItemStack.func_77973_b();
                Item materialItem = armor.func_82812_d().func_151685_b();
                if (materialItem == Items.field_151116_aA) {
                    return super.func_149668_a(world, i, j, k);
                }
                if (materialItem == LOTRMod.fur) {
                    return super.func_149668_a(world, i, j, k);
                }
                if (armor.func_82812_d() == LOTRMaterial.FUR.toArmorMaterial()) {
                    return super.func_149668_a(world, i, j, k);
                }
                if (armor.func_82812_d() != LOTRMaterial.MELKOQUENDI_RANGER.toArmorMaterial()) continue;
                return super.func_149668_a(world, i, j, k);
            }
            if (entity instanceof LOTREntityElf) {
                return super.func_149668_a(world, i, j, k);
            }
            if (entity instanceof LOTREntityAngbandBerserker2) {
                return super.func_149668_a(world, i, j, k);
            }
            if (!(entity instanceof LOTREntityFox)) continue;
            return super.func_149668_a(world, i, j, k);
        }
        return null;
    }

    private LOTRFaction.FactionType getPriorityFactionType(EnumSet<LOTRFaction.FactionType> factionTypes) {
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ELF)) {
            return LOTRFaction.FactionType.TYPE_ELF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_DWARF)) {
            return LOTRFaction.FactionType.TYPE_DWARF;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_MAN)) {
            return LOTRFaction.FactionType.TYPE_MAN;
        }
        if (factionTypes.contains((Object)LOTRFaction.FactionType.TYPE_ORC)) {
            return LOTRFaction.FactionType.TYPE_ORC;
        }
        return LOTRFaction.FactionType.TYPE_FREE;
    }

    public Item func_149650_a(int i, Random random, int j) {
        return null;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        ItemStack currentItem = player.func_71045_bC();
        if (currentItem != null && currentItem.func_77973_b() == Items.field_151133_ar && world.func_147439_a(x, y, z) == this) {
            if (!world.field_72995_K) {
                world.func_147468_f(x, y, z);
                if (!player.field_71075_bZ.field_75098_d) {
                    --currentItem.field_77994_a;
                    if (currentItem.field_77994_a <= 0) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, new ItemStack(LOTRMod.bucketSnow));
                    } else {
                        player.field_71071_by.func_70441_a(new ItemStack(LOTRMod.bucketSnow));
                    }
                    ((EntityPlayerMP)player).func_71120_a(player.field_71069_bz);
                }
            }
            return true;
        }
        return false;
    }

    public void func_149670_a(World world, int i, int j, int k, Entity entity) {
        if (!world.field_72995_K) {
            long currentTime = System.currentTimeMillis();
            if (entity instanceof EntityPlayerMP) {
                LOTRDamage.doFrostDamage((EntityPlayerMP)entity);
            }
            if (entity instanceof EntityLivingBase) {
                EntityLivingBase livingEntity = (EntityLivingBase)entity;
                long lastDamageTime = this.lastDamageTimeMap.getOrDefault(entity, 0L);
                livingEntity.field_70143_R = 0.0f;
                if (currentTime - lastDamageTime >= 2000L) {
                    entity.func_70097_a(LOTRDamage.frost, 1.0f);
                    this.lastDamageTimeMap.put(entity, currentTime);
                }
                if (!livingEntity.func_70644_a(Potion.field_76421_d)) {
                    livingEntity.func_70690_d(new PotionEffect(Potion.field_76421_d.field_76415_H, 80, 1));
                }
            }
        }
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        EntityPlayer player = world.func_72977_a((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, 5.0);
        if (player != null && LOTREnchantmentHelper.isSilkTouch(player.func_70694_bm())) {
            drops.add(new ItemStack((Block)this));
        }
        return drops;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_149646_a(IBlockAccess world, int x, int y, int z, int side) {
        return world.func_147439_a(x, y, z) != this && super.func_149646_a(world, x, y, z, side);
    }
}

